package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhangjing
 * @date 2022/1/4 10:34 上午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SpuSearchReq {

    /**
     * 必填, 商品标题,模糊搜索
     */
    private String keyword;

    /**
     * 商品状态,默认5
     * <p>
     * 枚举值	描述
     * 0	初始值
     * 5	上架
     * 6	回收站
     * 9	逻辑删除
     * 11	自主下架
     * 12	售磬下架
     * 13	违规下架/风控系统下架
     */
    private Integer status;

    /**
     * 必填, 默认1, 1: 小商店自营商品, 2:带货商品
     */
    private Integer source;

    /**
     * 必填, 第几页（最小填1）
     */
    private Integer page;

    /**
     * 必填, 每页数量(不超过10,000)
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}
