package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req;

import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.AppletJumpWxa;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;

import java.util.Date;

@Data
public class AppletGenerateSchemeReq {

    /**
     * 跳转到的目标小程序信息
     */
    @JsonProperty("jump_wxa")
    private AppletJumpWxa jumpWxa;

    /**
     * 生成的 scheme 码类型，
     * 到期失效：true，永久有效：false
     *  永久有效 上线为 10万条 超过180天或永久有效
     *  到期失效 不设上线  不超过180天
     *  单个小程序每日生成 Scheme 上限为50万个
     *
     * */
    @JsonProperty("is_expire")
    private Boolean isExpire;

    /**
     * 到期失效的 scheme 码的失效时间，为 Unix 时间戳。生成的到期失效 scheme 码在该时间前有效。最长有效期为30天。is_expire 为 true 且 expire_type 为 0 时必填
     */
    @JsonProperty("expire_time")
    private Date expireTime;

    /**
     * 默认值0，到期失效的 scheme 码失效类型，失效时间：0，失效间隔天数：1
     */
    @JsonProperty("expire_type")
    private Integer expireType;

    /**
     * 到期失效的 scheme 码的失效间隔天数。生成的到期失效 scheme 码在该间隔时间到达前有效。最长间隔天数为30天。is_expire 为 true 且 expire_type 为 1 时必填
     */
    @JsonProperty("expire_interval")
    private Integer expireInterval;

    public void validate() {
        if (isExpire != null && isExpire && expireType != null) {
            if (expireType == 0) {
                Preconditions.checkArgument(expireTime != null, "到期失效时间必传");
            }
            if (expireType == 1) {
                Preconditions.checkArgument(expireInterval != null, "到期失效天数必传");
            }
        }
    }
}
