/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信卡劵消息
 * 
 * @title WxCardMsg
 * @desc 微信卡劵消息
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxCardMsg extends BaseRespMsg {

    private static final long serialVersionUID = 5787817364307103143L;

    /**
     * 卡劵ID
     */
    @JsonProperty("card_id")
    private String cardId;

    /**
     * 卡券扩展信息，例如:
     * <pre>
     * "card_ext" : {
     *   "code"      : "",
     *   "openid"    : "",
     *   "timestamp" : "1402057159",
     *   "signature" : "017bb17407c8e0058a66d72dcc61632b70f511ad"
     * }
     * </pre>
     */
    @JsonProperty("card_ext")
    private Map<String, Object> cardExt;

    public WxCardMsg() {
        this.msgType = WxMsgType.WxCard.getValue();
    }

    @Override
    public String toXml() {
        throw new UnsupportedOperationException("此类消息不支持以XML格式回复给用户");
    }
}