/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.api.custom.WxCustomMsgAPI;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 发送菜单消息
 * 
 * @title MenuMsg
 * @desc 发送菜单消息
 * @author yanmaoyuan
 * @date 2019年4月29日
 * @version 1.0
 * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140547">客服接口-发消息</a>
 * @see WxCustomMsgAPI#checkCustomMsgType
 * @see WxMsgType#MsgMenu
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MenuMsg extends BaseRespMsg {

    private static final long serialVersionUID = 6525209330864878459L;

    @JsonProperty("head_content")
    private String headContent;

    private List<MenuItem> list;
    
    @JsonProperty("tail_content")
    private String tailContent;

    public MenuMsg() {
        this.msgType = WxMsgType.MsgMenu.getValue();
        this.list = Lists.newArrayList();
    }

    /**
     * 添加菜单项
     * 
     * @param id
     * @param content
     */
    public void addItem(String id, String content) {
        list.add(new MenuItem(id, content));
    }

    /**
     * 添加菜单项
     * 
     * @param item
     */
    public void addItem(MenuItem item) {
        if (item != null) {
            list.add(item);
        }
    }

    @Override
    public String toXml() {
        throw new UnsupportedOperationException("此类消息不支持以XML格式回复给用户");
    }
}