package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName LocationSelectEvent
 * @Description location_select：弹出地理位置选择器的事件推送
 * @Author zhangjing
 * @DATE 2019/4/26 10:39
 * @Version 1.0
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class LocationSelectEvent extends BaseEvent {

    private static final long serialVersionUID = 4981794527611570730L;

    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    /**
     * 发送的位置信息
     */
    @JacksonXmlProperty(localName = "SendLocationInfo")
    private SendLocationInfo sendLocationInfo;
}

@Data
class SendLocationInfo {
    /**
     * X坐标信息
     */
    @JacksonXmlProperty(localName = "Location_X")
    private Double locationX;

    /**
     * Y坐标信息
     */
    @JacksonXmlProperty(localName = "Location_Y")
    private Double LocationY;

    /**
     * 精度，可理解为精度或者比例尺、越精细的话 scale越高
     */
    @JacksonXmlProperty(localName = "Scale")
    private Integer scale;

    /**
     * 地理位置的字符串信息
     */
    @JacksonXmlProperty(localName = "Label")
    private String label;

    /**
     * 朋友圈POI的名字，可能为空
     */
    @JacksonXmlProperty(localName = "Poiname")
    private String poiname;
}
