/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.enums.custom;

/**
 * 客服绑定微信的邀请状态
 * 
 * <p>
 * WARN:请不要修改这个枚举变量名的大小写
 * </p>
 * 
 * @title WxInviteStatus
 * @desc 客服绑定微信的邀请状态
 * @author yanmaoyuan
 * @date 2019年4月30日
 * @version 1.0
 * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1458044813">客服管理-获取客服基本信息</a>
 */
@SuppressWarnings("squid:S115")
public enum WxInviteStatus {

    /**
     * 等待确认“waiting”
     */
    waiting,

    /**
     * 被拒绝“rejected”
     */
    rejected,

    /**
     * 过期“expired”
     */
    expired;

    /**
     * 获取邀请状态
     * 
     * @param value
     * @return
     */
    public static WxInviteStatus get(String value) {
        if (value == null) {
            return null;
        }

        return valueOf(value.toLowerCase());
    }
}