package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhangjing
 * @date 2022/1/4 4:33 下午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class OrderGetListReq {

    /**
     * 非必填, 订单创建时间的搜索开始时间
     */
    @JsonProperty("start_create_time")
    private String startCreateTime;

    /**
     * 非必填, 订单创建时间的搜索结束时间
     */
    @JsonProperty("end_create_time")
    private String endCreateTime;

    /**
     * 非必填, 订单更新时间的搜索开始时间
     */
    @JsonProperty("start_update_time")
    private String startUpdateTime;

    /**
     * 非必填, 订单更新时间的搜索结束时间
     */
    @JsonProperty("end_update_time")
    private String endUpdateTime;

    /**
     * 必填, 状态, 订单状态
     */
    private Integer status;

    /**
     * 必填, 第几页（最小填1）
     */
    private Integer page;

    /**
     * 必填, 每页数量(不超过10,000)
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 非必填, 1:小商店,2:CPS带货
     */
    private Integer source;

}
