package cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/5 6:41 下午
 */
@Data
public class UserCouponItem {

    /**
     * 优惠券id
     */
    @JsonAlias("coupon_id")
    private Long couponId;

    /**
     * 优惠券状态
     *
     * 枚举字段	枚举值	描述
     * COUPON_USER_STATUS_VALID	100	生效中
     * COUPON_USER_STATUS_EXPIRED	101	已过期
     * COUPON_USER_STATUS_USED	102	已使用
     */
    private String status;

    /**
     * 优惠券派发时间
     */
    @JsonAlias("create_time")
    private String createTime;

    /**
     * 优惠券更新时间
     */
    @JsonAlias("update_time")
    private String updateTime;

    /**
     * 优惠券生效时间
     */
    @JsonAlias("start_time")
    private String startTime;

    /**
     * 优惠券失效时间
     */
    @JsonAlias("end_time")
    private String endTime;

    @JsonAlias("ext_info")
    private UserCouponExtInfo extInfo;

    /**
     * 优惠券使用的订单id
     */
    @JsonAlias("order_id")
    private Long orderId;

    /**
     * 优惠券金额
     */
    @JsonAlias("discount_fee")
    private Long discountFee;
}
