package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class PlainJsCode2Session {
    /**
     * 小程序appId
     */
    @JsonProperty("appid")
    private String appId;

    /**
     * 小程序 appSecret
     */
    @JsonProperty("secret")
    private String secret;

    /**
     * 登录时获取的 code
     */
    @JsonProperty("js_code")
    private String jsCode;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(appId), "appId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(secret), "secret不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(jsCode), "jsCode不能为空");
    }
}
