/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.mass.req;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 删除群发消息
 * 
 * @title DelMassMsg
 * @desc 删除群发消息
 * @author yanmaoyuan
 * @date 2019年4月29日
 * @version 1.0
 */
@Data
public class DelMassMsg implements Serializable {

    private static final long serialVersionUID = -7801734059772077602L;

    /**
     * 发送出去的消息ID
     */
    @JsonProperty("msg_id")
    private String msgId;

    /**
     * 要删除的文章在图文消息中的位置，第一篇编号为1，该字段不填或填0会删除全部文章
     */
    @JsonProperty("article_idx")
    private Integer articleIdx;
}