package cn.kinyun.scrm.weixin.sdk.entity.message.event.menu;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.BaseEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName ViewMiniProgramEvent
 * @Description 点击菜单跳转小程序的事件推送
 * @Author zhangjing
 * @DATE 2019/4/26 10:48
 * @Version 1.0
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ViewMiniProgramEvent extends BaseEvent{

    private static final long serialVersionUID = -155976085585660639L;

    /**
     * 事件KEY值，跳转的小程序路径。
     */
    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    /**
     * 菜单ID，如果是个性化菜单，则可以通过这个字段，知道是哪个规则的菜单被点击了。
     */
    @JacksonXmlProperty(localName = "MenuId")
    private String menuId;
}
