package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName ScancodeWaitMsgEvent
 * @Description scancode_waitmsg：扫码推事件且弹出“消息接收中”提示框的事件推送
 * @Author zhangjing
 * @DATE 2019/4/26 10:14
 * @Version 1.0
 */
@Data
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper=true)
public class ScanCodeWaitMsgEvent extends BaseEvent {

    private static final long serialVersionUID = 3148894029834225711L;

    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    @JacksonXmlProperty(localName = "ScanCodeInfo")
    private ScanCodeInfo scanCodeInfo;
}
