package cn.kinyun.scrm.weixin.sdk.api.component;

import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizeMsg;
import cn.kinyun.scrm.weixin.sdk.entity.component.BaseMsg;
import cn.kinyun.scrm.weixin.sdk.entity.component.TicketMsg;
import cn.kinyun.scrm.weixin.sdk.enums.component.InfoType;
import cn.kinyun.scrm.weixin.sdk.utils.aes.WXBizMsgCrypt;
import cn.kinyun.scrm.weixin.sdk.utils.aes.XMLParser;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import lombok.NonNull;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.component.api
 * @Description: 消息处理
 * @date Date : 2019年04月25日 10:08
 */
public class ComponentMsgAPI {

    /**
     * 解析推送消息
     *
     * @param request   请求
     * @param token     第三方平台账号注册时填写的token
     * @param encodingAesKey 第三方平台账号注册时填写的aeskey
     * @param appId   第三方平台appId
     * @return  返回消息实体
     * @throws Exception 异常
     */
    public static BaseMsg praseMsg(@NonNull HttpServletRequest request, @NonNull String token, @NonNull String encodingAesKey, @NonNull String appId) throws Exception {
        String msgSignature = request.getParameter("msg_signature");
        String timeStamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");

        try(BufferedReader br = new BufferedReader(new InputStreamReader(request.getInputStream()))) {
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String postData = sb.toString();
            WXBizMsgCrypt wxBizMsgCrypt = new WXBizMsgCrypt(token, encodingAesKey, appId);
            String xmlText = wxBizMsgCrypt.decryptMsg(msgSignature, timeStamp, nonce, postData);
            Map<String, String> baseMsgMap = XMLParser.xmlToMap(xmlText);
            BaseMsg baseMsg = new BaseMsg();
            baseMsg.setAppId(baseMsgMap.get("AppId"));
            baseMsg.setCreateTime(baseMsgMap.get("CreateTime"));
            baseMsg.setInfoType("InfoType");

            if (InfoType.component_verify_ticket.getType().equals(baseMsg.getInfoType())) {
                return praseTicketMsg(xmlText, baseMsg);
            } else if (InfoType.authorized.getType().equals(baseMsg.getInfoType())) {
                return praseAuthorizeMsg(xmlText, baseMsg);
            } else if (InfoType.unauthorized.getType().equals(baseMsg.getInfoType())) {
                return praseAuthorizeMsg(xmlText, baseMsg);
            } else if (InfoType.updateauthorized.getType().equals(baseMsg.getInfoType())) {
                return praseAuthorizeMsg(xmlText, baseMsg);
            } else {
                return baseMsg;
            }
        }
    }

    /**
     * 解析ticket消息
     *
     * @param xmlText
     * @param baseMsg
     * @return
     * @throws Exception
     */
    private static TicketMsg praseTicketMsg(String xmlText, BaseMsg baseMsg) throws Exception {
        Map<String, String> ticketMsgMap = XMLParser.xmlToMap(xmlText);
        TicketMsg ticketMsg = new TicketMsg();
        ticketMsg.setComponentVerifyTicket(ticketMsgMap.get("ComponentVerifyTicket"));
        ticketMsg.setAppId(baseMsg.getAppId());
        ticketMsg.setCreateTime(baseMsg.getCreateTime());
        ticketMsg.setInfoType(baseMsg.getInfoType());
        return ticketMsg;
    }

    /**
     * 解析授权相关消息
     *
     * @param xmlText
     * @param baseMsg
     * @return
     * @throws Exception
     */
    private static AuthorizeMsg praseAuthorizeMsg(String xmlText, BaseMsg baseMsg) throws Exception {
        Map<String, String> authorizeMsgMap = XMLParser.xmlToMap(xmlText);
        AuthorizeMsg authorizeMsg = new AuthorizeMsg();
        authorizeMsg.setAppId(baseMsg.getAppId());
        authorizeMsg.setCreateTime(baseMsg.getCreateTime());
        authorizeMsg.setInfoType(baseMsg.getInfoType());
        authorizeMsg.setAuthorizerAppid(authorizeMsgMap.get("AuthorizerAppid"));
        authorizeMsg.setAuthorizationCode(authorizeMsgMap.get("AuthorizationCode"));
        authorizeMsg.setAuthorizationCodeExpiredTime(Long.parseLong(authorizeMsgMap.get("AuthorizationCodeExpiredTime")));
        authorizeMsg.setPreAuthCode(authorizeMsgMap.get("PreAuthCode"));
        return authorizeMsg;
    }
}
