/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.utils.aes;

import cn.kinyun.scrm.weixin.sdk.utils.aes.AesException;
import cn.kinyun.scrm.weixin.sdk.utils.aes.ByteGroup;
import cn.kinyun.scrm.weixin.sdk.utils.aes.PKCS7Encoder;
import cn.kinyun.scrm.weixin.sdk.utils.aes.SHA1;
import cn.kinyun.scrm.weixin.sdk.utils.aes.XMLParser;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class WXBizMsgCrypt {
    static Charset CHARSET = Charset.forName("utf-8");
    Base64 base64 = new Base64();
    byte[] aesKey;
    String token;
    String appId;
    private Random random = new Random();

    public static void main(String[] args) {
        String token = "AAAAA";
        String encodingAesKey = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
        String appId = "wxba5fad812f8e6fb9";
        try {
            WXBizMsgCrypt pc = new WXBizMsgCrypt(token, encodingAesKey, appId);
            String msg = "{\n    \"ToUserName\": \"gh_97417a04a28d\",\n    \"Encrypt\": \"+qdx1OKCy+5JPCBFWw70tm0fJGb2Jmeia4FCB7kao+/Q5c/ohsOzQHi8khUOb05JCpj0JB4RvQMkUyus8TPxLKJGQqcvZqzDpVzazhZv6JsXUnnR8XGT740XgXZUXQ7vJVnAG+tE8NUd4yFyjPy7GgiaviNrlCTj+l5kdfMuFUPpRSrfMZuMcp3Fn2Pede2IuQrKEYwKSqFIZoNqJ4M8EajAsjLY2km32IIjdf8YL/P50F7mStwntrA2cPDrM1kb6mOcfBgRtWygb3VIYnSeOBrebufAlr7F9mFUPAJGj04=\"\n}";
            String decryptMsg = pc.decryptJsonMsg("046e02f8204d34f8ba5fa3b1db94908f3df2e9b3", "1714112445", "415670741", msg);
            System.out.println(decryptMsg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public WXBizMsgCrypt(String token, String encodingAesKey, String appId) throws AesException {
        if (encodingAesKey.length() != 43) {
            throw new AesException(-40004);
        }
        this.token = token;
        this.appId = appId;
        this.aesKey = Base64.decodeBase64((String)(encodingAesKey + "="));
    }

    byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    String getRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int number = this.random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    String encrypt(String randomStr, String text) throws AesException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] appidBytes = this.appId.getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(appidBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            String base64Encrypted = this.base64.encodeToString(encrypted);
            return base64Encrypted;
        }
        catch (Exception e) {
            throw new AesException(-40006);
        }
    }

    String decrypt(String text) throws AesException {
        String from_appid;
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.decodeBase64((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new AesException(-40007);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_appid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            throw new AesException(-40008);
        }
        if (!from_appid.equals(this.appId)) {
            throw new AesException(-40005);
        }
        return xmlContent;
    }

    public String encryptMsg(String replyMsg, String timestamp, String nonce) throws AesException {
        String encrypt = this.encrypt(this.getRandomStr(), replyMsg);
        if (timestamp == null || timestamp.isEmpty()) {
            timestamp = Long.toString(System.currentTimeMillis());
        }
        if (nonce == null || nonce.isEmpty()) {
            nonce = this.getRandomStr();
        }
        String signature = SHA1.getSHA1(this.token, timestamp, nonce, encrypt);
        String result = XMLParser.generate(encrypt, signature, timestamp, nonce);
        return result;
    }

    public String decryptMsg(String msgSignature, String timeStamp, String nonce, String postData) throws AesException {
        Map<String, String> map = XMLParser.xmlToMap(postData);
        String encrypt = map.get("Encrypt");
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        String result = this.decrypt(encrypt);
        return result;
    }

    public String decryptJsonMsg(String msgSignature, String timeStamp, String nonce, String postData) throws AesException {
        JSONObject map = JSONObject.parseObject((String)postData);
        String encrypt = map.getString("Encrypt");
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        String result = this.decrypt(encrypt);
        return result;
    }

    public String verifyUrl(String msgSignature, String timeStamp, String nonce, String echoStr) throws AesException {
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, echoStr);
        if (!signature.equalsIgnoreCase(msgSignature)) {
            throw new AesException(-40001);
        }
        String result = this.decrypt(echoStr);
        return result;
    }
}

