/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.utils;

import cn.kinyun.scrm.weixin.sdk.entity.HttpResponse;
import cn.kinyun.scrm.weixin.sdk.entity.media.Attachment;
import cn.kinyun.scrm.weixin.sdk.utils.HttpClient;
import cn.kinyun.scrm.weixin.sdk.utils.WxX509TrustManager;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpsClient {
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;
    private static final String POST = "POST";

    public HttpsURLConnection getHttpsURLConnection(String url) throws IOException {
        URL urlGet = new URL(url);
        HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)urlGet.openConnection();
        return httpsUrlConnection;
    }

    public void setHttpsHeader(HttpsURLConnection httpsUrlConnection, String method, boolean needCert, String partnerId, String certPath, String certSecret) throws IOException, GeneralSecurityException {
        if (httpsUrlConnection == null) {
            throw new NullPointerException("httpsUrlConnection can not be null");
        }
        if (needCert) {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream instream = new FileInputStream(new File(certPath));){
                keyStore.load(instream, partnerId.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, certSecret.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(kmf.getKeyManagers(), null, null);
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            httpsUrlConnection.setSSLSocketFactory(ssf);
        } else {
            TrustManager[] tm = new TrustManager[]{new WxX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            httpsUrlConnection.setSSLSocketFactory(ssf);
        }
        httpsUrlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36");
        httpsUrlConnection.setDoOutput(true);
        httpsUrlConnection.setDoInput(true);
        httpsUrlConnection.setRequestMethod(method);
        httpsUrlConnection.setConnectTimeout(30000);
        httpsUrlConnection.setReadTimeout(30000);
        httpsUrlConnection.setRequestProperty("Charsert", "UTF-8");
        httpsUrlConnection.setUseCaches(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadHttps(String url, File file) throws Exception {
        StringBuffer bufferRes;
        HttpsURLConnection https = null;
        try {
            String BOUNDARY = "----WebKitFormBoundaryiDGnV9zdZA1eM1yL";
            https = this.getHttpsURLConnection(url);
            this.setHttpsHeader(https, POST, false, null, null, null);
            https.setUseCaches(false);
            https.setRequestProperty("connection", "Keep-Alive");
            https.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            try (OutputStream out = null;
                 DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
                int bytes;
                out = new DataOutputStream(https.getOutputStream());
                byte[] end_data = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
                StringBuilder sb = new StringBuilder();
                sb.append("--");
                sb.append(BOUNDARY);
                sb.append("\r\n");
                sb.append("Content-Disposition: form-data;name=\"media\";filename=\"").append(file.getName()).append("\"\r\n");
                sb.append("Content-Type:application/octet-stream\r\n\r\n");
                byte[] data = sb.toString().getBytes();
                out.write(data);
                byte[] bufferOut = new byte[1024];
                while ((bytes = dataInputStream.read(bufferOut)) != -1) {
                    out.write(bufferOut, 0, bytes);
                }
                out.write("\r\n".getBytes());
                out.write(end_data);
                out.flush();
            }
            try (InputStream ins = https.getInputStream();
                 BufferedReader read = new BufferedReader(new InputStreamReader(ins, StandardCharsets.UTF_8));){
                String valueString;
                bufferRes = new StringBuffer();
                while ((valueString = read.readLine()) != null) {
                    bufferRes.append(valueString);
                }
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException ex) {
            throw new Exception(ex.getMessage(), ex);
        }
        finally {
            if (https != null) {
                https.disconnect();
            }
        }
        return bufferRes.toString();
    }

    public HttpResponse requestHttps(@NonNull String url, String json) throws IOException, GeneralSecurityException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        HttpsURLConnection https = this.getHttpsURLConnection(url);
        this.setHttpsHeader(https, POST, false, null, null, null);
        https.setRequestProperty("connection", "Keep-Alive");
        https.connect();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            OutputStream os = https.getOutputStream();
            os.write(json.getBytes("UTF-8"));
            os.close();
        }
        InputStream in = https.getInputStream();
        HttpResponse response = new HttpResponse();
        response.setContentType(https.getContentType());
        response.setInputStream(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)in)));
        response.setContentDisposition(https.getHeaderField("Content-disposition"));
        response.setContentLength(https.getHeaderField("Content-Length"));
        response.setHeaders(https.getHeaderFields());
        in.close();
        https.disconnect();
        return response;
    }

    public Attachment downloadHttps(String url) throws IOException, GeneralSecurityException {
        Attachment attachment;
        block30: {
            attachment = null;
            HttpsURLConnection https = null;
            try {
                https = this.getHttpsURLConnection(url);
                this.setHttpsHeader(https, POST, false, null, null, null);
                https.setRequestProperty("connection", "Keep-Alive");
                https.connect();
                InputStream in = https.getInputStream();
                attachment = new Attachment();
                String contentType = https.getContentType();
                if (contentType.contains("text/plain") || contentType.contains("application/json")) {
                    JSONObject result;
                    Object valueString;
                    StringBuilder bufferRes = new StringBuilder();
                    try (BufferedReader read = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                        while ((valueString = read.readLine()) != null) {
                            bufferRes.append((String)valueString);
                        }
                    }
                    String textString = bufferRes.toString();
                    if (textString.contains("errcode") && (result = JSONObject.parseObject((String)textString)).containsKey((Object)"errcode") && result.getIntValue("errcode") != 0) {
                        attachment.setErrCode(result.getInteger("errcode"));
                        attachment.setErrMsg(result.getString("errmsg"));
                        valueString = attachment;
                        return valueString;
                    }
                    if (textString.contains("video_url")) {
                        result = JSONObject.parseObject((String)textString);
                        if (result.containsKey((Object)"video_url")) {
                            HttpClient httpClient = new HttpClient();
                            attachment = httpClient.download(result.getString("video_url"));
                        } else {
                            attachment.setErrCode(-1);
                            attachment.setErrMsg(textString);
                        }
                    } else {
                        attachment.setErrCode(-1);
                        attachment.setErrMsg(textString);
                    }
                    break block30;
                }
                byte[] data = IOUtils.toByteArray((InputStream)in);
                String ds = https.getHeaderField("Content-disposition");
                String fileName = "";
                if (ds.contains("attachment;")) {
                    fileName = ds.substring(ds.indexOf("filename=") + 10, ds.length());
                } else if (ds.contains("form-data;")) {
                    fileName = ds.substring(ds.indexOf("filename=\"") + 10, ds.length() - 1);
                }
                attachment.setFileName(fileName);
                attachment.setContentLength(https.getHeaderField("Content-Length"));
                attachment.setContentType(https.getHeaderField("Content-Type"));
                attachment.setInputStream(new ByteArrayInputStream(data));
            }
            catch (IOException | GeneralSecurityException e) {
                throw e;
            }
            finally {
                if (https != null) {
                    https.disconnect();
                }
            }
        }
        return attachment;
    }
}

