/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PicFile;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.DateUtil;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OrganizationCodeInfo {
    @JsonProperty(value="pic_file")
    private PicFile picFile;
    @JsonProperty(value="organization_code")
    private String organizationCode;
    @JsonProperty(value="start_date")
    private String startDate;
    @JsonProperty(value="end_date")
    private String endDate;

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.picFile), (Object)"picFile\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.organizationCode), (Object)"organizationCode\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.startDate) && this.startDate.matches("\\d{4}\\-\\d{2}\\-\\d{2}") ? 1 : 0) != 0, (Object)"startDate\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u683c\u5f0f\u4e3a:2014-01-01");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.endDate), (Object)"endDate\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.endDate.matches("\\d{4}\\-\\d{2}\\-\\d{2}")) {
            Date startTime = DateUtil.getStrToDate((String)this.startDate, (String)"yyyy-MM-dd");
            Date endTime = DateUtil.getStrToDate((String)this.endDate, (String)"yyyy-MM-dd");
            Preconditions.checkArgument((boolean)endTime.after(startTime), (Object)"endTime\u9700\u8981\u5927\u4e8estartTime");
            Preconditions.checkArgument((DateUtil.getDateDiff((Date)new Date(), (Date)endTime) > 60 ? 1 : 0) != 0, (Object)"\u5269\u4f59\u6709\u6548\u671f\u5fc5\u987b\u5927\u4e8e60\u5929");
        } else {
            Preconditions.checkArgument((boolean)this.endDate.equals("\u957f\u671f"), (Object)"endDate\u4e0d\u5408\u6cd5");
        }
    }

    public OrganizationCodeInfo() {
    }

    public OrganizationCodeInfo(PicFile picFile, String organizationCode, String startDate, String endDate) {
        this.picFile = picFile;
        this.organizationCode = organizationCode;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public PicFile getPicFile() {
        return this.picFile;
    }

    public String getOrganizationCode() {
        return this.organizationCode;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="pic_file")
    public void setPicFile(PicFile picFile) {
        this.picFile = picFile;
    }

    @JsonProperty(value="organization_code")
    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="end_date")
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrganizationCodeInfo)) {
            return false;
        }
        OrganizationCodeInfo other = (OrganizationCodeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PicFile this$picFile = this.getPicFile();
        PicFile other$picFile = other.getPicFile();
        if (this$picFile == null ? other$picFile != null : !((Object)this$picFile).equals(other$picFile)) {
            return false;
        }
        String this$organizationCode = this.getOrganizationCode();
        String other$organizationCode = other.getOrganizationCode();
        if (this$organizationCode == null ? other$organizationCode != null : !this$organizationCode.equals(other$organizationCode)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        return !(this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrganizationCodeInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PicFile $picFile = this.getPicFile();
        result = result * 59 + ($picFile == null ? 43 : ((Object)$picFile).hashCode());
        String $organizationCode = this.getOrganizationCode();
        result = result * 59 + ($organizationCode == null ? 43 : $organizationCode.hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        return result;
    }

    public String toString() {
        return "OrganizationCodeInfo(picFile=" + this.getPicFile() + ", organizationCode=" + this.getOrganizationCode() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ")";
    }
}

