/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.channels;

import cn.kinyun.scrm.weixin.sdk.entity.channels.req.ProductGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.channels.resp.ProductGetResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxChannelsProductAPI {
    private static final Logger log = LoggerFactory.getLogger(WxChannelsProductAPI.class);
    @Value(value="${wx.channels.product.get}")
    private String productGetUrl;
    @Autowired
    private RestTemplate restTemplate;

    public ProductGetResp productGet(@NonNull String accessToken, @NonNull ProductGetReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("productGet with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.productGetUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ProductGetResp.class, new Object[0]);
        ProductGetResp result = (ProductGetResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

