/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.channels;

import cn.kinyun.scrm.weixin.sdk.entity.channels.req.OrderListGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.channels.resp.OrderGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.channels.resp.OrderListGetResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxChannelsOrderAPI {
    private static final Logger log = LoggerFactory.getLogger(WxChannelsOrderAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.channels.order.list.get}")
    private String orderListGetUrl;
    @Value(value="${wx.channels.order.get}")
    private String orderGetUrl;

    public OrderListGetResp orderListGet(@NonNull String accessToken, @NonNull OrderListGetReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("orderListGet with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.orderListGetUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, OrderListGetResp.class, new Object[0]);
        OrderListGetResp result = (OrderListGetResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public OrderGetResp orderGet(@NonNull String accessToken, @NonNull String orderId) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (orderId == null) {
            throw new NullPointerException("orderId is marked non-null but is null");
        }
        log.info("orderGet with orderId={}", (Object)orderId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orderId}), (Object)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap req = Maps.newHashMap();
        req.put("order_id", orderId);
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.orderGetUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, OrderGetResp.class, new Object[0]);
        OrderGetResp result = (OrderGetResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

