/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api;

import cn.kinyun.scrm.weixin.sdk.api.WxMediaAPI;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.media.MediaResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.req.DelMassMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp.MsgId;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp.MsgStatus;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp.SendSpeed;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.ImageMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MpNewsMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MpVideoMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.TextMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.VideoMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.VoiceMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.WxCardMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgStatus;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxMassMsgAPI {
    private static final Logger log = LoggerFactory.getLogger(WxMassMsgAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WxMediaAPI wxMediaAPI;
    @Value(value="${wx.message.mass.sendall}")
    private String wxMessageMassSendAll;
    @Value(value="${wx.message.mass.send}")
    private String wxMessageMassSend;
    @Value(value="${wx.message.mass.delete}")
    private String wxMessageMassDelete;
    @Value(value="${wx.message.mass.preview}")
    private String wxMessageMassPreview;
    @Value(value="${wx.message.mass.get}")
    private String wxMessageMassGet;
    @Value(value="${wx.message.mass.speed.get}")
    private String wxMessageMassGetSpeed;
    @Value(value="${wx.message.mass.speed.set}")
    private String wxMessageMassSetSpeed;

    public MsgId sendToAll(@NonNull String accessToken, @NonNull BaseRespMsg message) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.sendByTag(accessToken, message, "");
    }

    public MsgId sendByTag(@NonNull String accessToken, @NonNull BaseRespMsg message, String tagId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        log.info("mass send all, message={}, tagId={}", (Object)message, (Object)tagId);
        HashMap params = Maps.newHashMap();
        HashMap filter = Maps.newHashMap();
        boolean isToAll = StringUtils.isBlank((CharSequence)tagId);
        filter.put("is_to_all", isToAll);
        if (!isToAll) {
            filter.put("tag_id", tagId);
        }
        params.put("filter", filter);
        HttpEntity<?> request = this.getMassSendRequest(accessToken, params, message);
        String url = MessageFormat.format(this.wxMessageMassSendAll, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, request, MsgId.class, new Object[0]);
        MsgId msgId = (MsgId)response.getBody();
        WeixinException.isSuccess(msgId);
        return msgId;
    }

    public MsgId sendByOpenId(@NonNull String accessToken, @NonNull BaseRespMsg message, @NonNull Collection<String> openIds) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (openIds == null) {
            throw new NullPointerException("openIds is marked non-null but is null");
        }
        log.info("mass send by openids, message={}, openIds={}", (Object)message, openIds);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(openIds), (Object)"\u5fae\u4fe1\u63a5\u6536\u8005\u7684openid\u4e0d\u53ef\u4e3a\u7a7a");
        Set<String> ids = openIds.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"\u5fae\u4fe1\u63a5\u6536\u8005\u7684openid\u4e0d\u53ef\u4e3a\u7a7a");
        HashMap params = Maps.newHashMap();
        params.put("touser", ids.toArray(new String[0]));
        HttpEntity<?> request = this.getMassSendRequest(accessToken, params, message);
        String url = MessageFormat.format(this.wxMessageMassSend, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, request, MsgId.class, new Object[0]);
        MsgId msgId = (MsgId)response.getBody();
        WeixinException.isSuccess(msgId);
        return msgId;
    }

    private void checkMassMsgType(@NonNull BaseRespMsg message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{message.getMsgType()}), (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        WxMsgType msgType = WxMsgType.get(message.getMsgType());
        Preconditions.checkArgument((msgType != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b");
        switch (msgType) {
            case MpNews: {
                Preconditions.checkArgument((boolean)(message instanceof MpNewsMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case MpVideo: {
                Preconditions.checkArgument((boolean)(message instanceof MpVideoMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case Text: {
                Preconditions.checkArgument((boolean)(message instanceof TextMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case Image: {
                Preconditions.checkArgument((boolean)(message instanceof ImageMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case Video: {
                Preconditions.checkArgument((boolean)(message instanceof VideoMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case Voice: {
                Preconditions.checkArgument((boolean)(message instanceof VoiceMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case WxCard: {
                Preconditions.checkArgument((boolean)(message instanceof WxCardMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4ec5\u652f\u6301\u7fa4\u53d1\u4e0b\u5217\u7c7b\u578b\u7684\u6d88\u606f\uff1a\u6587\u672c(text), \u56fe\u7247(image), \u56fe\u6587(mpnews), \u8bed\u97f3/\u97f3\u9891(voice), \u89c6\u9891(mpvideo), \u5361\u5238(wxcard)");
            }
        }
    }

    private HttpEntity<?> getMassSendRequest(@NonNull String accessToken, Map<String, Object> params, BaseRespMsg message) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        this.checkMassMsgType(message);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        params.put("msgtype", message.getMsgType());
        params.put(message.getMsgType(), message);
        if (message.getSendIgnoreReprint() != null && message.getSendIgnoreReprint() != 0) {
            params.put("send_ignore_reprint", 1);
        }
        if (message.getClientMsgId() != null) {
            params.put("clientmsgid", message.getClientMsgId());
        }
        byte[] data = JacksonUtil.obj2Str(params).getBytes();
        return new HttpEntity((Object)data, (MultiValueMap)headers);
    }

    public MpVideoMsg convertToMpVideo(@NonNull String accessToken, @NonNull VideoMsg videoMsg) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (videoMsg == null) {
            throw new NullPointerException("videoMsg is marked non-null but is null");
        }
        log.info("Convert {} to MpVideoMsg", (Object)videoMsg);
        MediaResult result = this.wxMediaAPI.uploadVideo(accessToken, videoMsg);
        MpVideoMsg msg = new MpVideoMsg();
        msg.setMediaId(result.getMediaId());
        return msg;
    }

    public void deleteMsg(@NonNull String accessToken, @NonNull DelMassMsg params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("delete mass message with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getMsgId()}), (Object)"\u6d88\u606fID\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxMessageMassDelete, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public MsgId previewWithOpenId(@NonNull String accessToken, @NonNull BaseRespMsg message, String openId, String wxName) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        log.info("preview msg with openId={}, wxname={}", (Object)openId, (Object)wxName);
        Preconditions.checkArgument((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wxName}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{"openId"}) ? 1 : 0) != 0, (Object)"openId\u548c\u5fae\u4fe1\u53f7\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap params = Maps.newHashMap();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wxName})) {
            params.put("towxname", wxName);
        } else {
            params.put("touser", openId);
        }
        HttpEntity<?> request = this.getMassSendRequest(accessToken, params, message);
        String url = MessageFormat.format(this.wxMessageMassPreview, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, request, MsgId.class, new Object[0]);
        MsgId msgId = (MsgId)response.getBody();
        WeixinException.isSuccess(msgId);
        return msgId;
    }

    public WxMsgStatus getMsgStatus(@NonNull String accessToken, @NonNull String msgId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (msgId == null) {
            throw new NullPointerException("msgId is marked non-null but is null");
        }
        log.info("get mass message status with msgId={}", (Object)msgId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msgId}), (Object)"\u6d88\u606fID\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("msg_id", msgId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxMessageMassGet, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, MsgStatus.class, new Object[0]);
        MsgStatus result = (MsgStatus)response.getBody();
        WeixinException.isSuccess(result);
        String msgStatus = result.getMsgStatus();
        return WxMsgStatus.valueOf(msgStatus);
    }

    public void setSpeed(@NonNull String accessToken, @NonNull Integer speed) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (speed == null) {
            throw new NullPointerException("speed is marked non-null but is null");
        }
        log.info("set mass send speed={}", (Object)speed);
        Preconditions.checkArgument((speed != null ? 1 : 0) != 0, (Object)"\u7fa4\u53d1\u901f\u5ea6\u53c2\u6570\u4e3anull");
        Preconditions.checkArgument((speed >= 0 && speed <= 4 ? 1 : 0) != 0, (Object)"\u7fa4\u53d1\u901f\u5ea6\u7ea7\u522b\u5e94\u8be5\u662f\u4e00\u4e2a0\u52304\u7684\u6574\u6570\u3002");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("speed", speed);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxMessageMassSetSpeed, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public SendSpeed getSpeed(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get mass send speed");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxMessageMassGetSpeed, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, SendSpeed.class, new Object[0]);
        SendSpeed result = (SendSpeed)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

