package cn.kinyun.scrm.weixin.sdk.entity.user.resp;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.io.Serializable;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.entity.user.resp
 * @Description: 粉丝列表
 * @date Date : 2019年04月25日 15:17
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UserListResp extends ErrorCode {
    private static final long serialVersionUID = 8177670722303985600L;

    private int total;

    private int count;

    @JsonAlias("next_openid")
    private String nextOpenId;

    private OpenIdData data;

    @Data
    public static class OpenIdData implements Serializable{
        private static final long serialVersionUID = 4424687146974914014L;

        @JsonAlias("openid")
        private List<String> openId;
    }
}
