/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.template;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 获取设置的行业信息
 * 
 * @title IndustryInfo
 * @desc 获取设置的行业信息
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class IndustryInfo extends ErrorCode {

    private static final long serialVersionUID = 2929901735530508862L;

    /**
     * 帐号设置的主营行业
     */
    @JsonProperty("primary_industry")
    private Industry primaryIndustry;

    /**
     * 帐号设置的副营行业
     */
    @JsonProperty("secondary_industry")
    private Industry secondaryIndustry;
}