package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ValidInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ValidInfoByCreate;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/5 4:06 下午
 */
@Data
public class CouponCreateReq {

    /**
     * 必传, 优惠券类型
     *
     *
     */
    private Integer type;

    /**
     * 必传, 优惠券名称
     */
    private String name;

    @JsonProperty("discount_info")
    private DiscountInfo discountInfo;

    @JsonProperty("ext_info")
    private ExtInfoByCreate extInfo;

    @JsonProperty("promote_info")
    private PromoteInfo promoteInfo;

    @JsonProperty("receive_info")
    private ReceiveInfoByCreate receiveInfo;

    @JsonProperty("valid_info")
    private ValidInfoByCreate validInfo;

    @JsonProperty("coupon_id")
    private Long couponId;

}
