package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.DateUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/30 7:19 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class IdCardInfo {

    /**
     * 人像面照片
     */
    @JsonProperty("portrait_pic_file")
    private PicFile portraitPicFile;

    /**
     * 国徽面照片
     */
    @JsonProperty("nation_pic_file")
    private PicFile nationPicFile;

    /**
     * 请填写经营者/法定代表人对应身份证的姓名，2~30个中文字符、英文字符、符号。
     */
    @JsonProperty("id_card_name")
    private String idCardName;

    /**
     * 请填写经营者/法定代表人对应身份证的号码
     */
    @JsonProperty("id_card_number")
    private String idCardNumber;

    /**
     * 注册日期，格式：2014-01-01
     */
    @JsonProperty("start_date")
    private String startDate;

    /**
     * 结束有效期，格式：2014-01-01
     * 1、若证件有效期为长期，请填写：长期。
     * 2、结束时间需大于开始时间。
     * 3、有效期必须大于60天，即结束时间距当前时间需超过60天。
     */
    @JsonProperty("end_date")
    private String endDate;

    public void validate(){


        Preconditions.checkArgument(StringUtils.isNotBlank(startDate) && startDate.matches(ConstStr.DATE_REG), "startDate不能为空,且格式为:2014-01-01");
        Preconditions.checkArgument(StringUtils.isNotBlank(endDate), "endDate不能为空");
        if (endDate.matches(ConstStr.DATE_REG)) {
            // 日期型
            Date startTime = DateUtil.getStrToDate(startDate, "yyyy-MM-dd");
            Date endTime = DateUtil.getStrToDate(endDate, "yyyy-MM-dd");
            Preconditions.checkArgument(endTime.after(startTime), "endTime需要大于startTime");
            Preconditions.checkArgument(DateUtil.getDateDiff(new Date(), endTime) > 60, "剩余有效期必须大于60天");
        } else {
            Preconditions.checkArgument(endDate.equals("长期"), "endDate不合法");
        }
    }
}
