package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/30 4:00 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class CheckAuditStatusData {

    /**
     * 注册状态 0:成功 1:已发送协议还未签约 2: 未发送协议或协议已过期，需发送协议，当register_status为0时以下字段有意义
     */
    @JsonProperty("register_status")
    private Integer registerStatus;

    /**
     * 商家信息状态
     *
     * {@link AuditStatus}
     */
    @JsonProperty("merchant_info_status")
    private Integer merchantInfoStatus;

    /**
     * 账户验证状态
     *
     * {@link AuditStatus}
     */
    @JsonProperty("acct_verify_status")
    private Integer acctVerifyStatus;

    /**
     * 基础信息状态
     *
     * {@link AuditStatus}
     */
    @JsonProperty("basic_info_status")
    private Integer basicInfoStatus;

    /**
     * 支付签约状态
     *
     * {@link AuditStatus}
     */
    @JsonProperty("pay_sign_status")
    private Integer paySignStatus;

    /**
     * 基础信息驳回原因
     */
    @JsonProperty("audit_reject_reasons")
    private String auditRejectReasons;

    /**
     * 法人验证链接
     */
    @JsonProperty("legal_validation_url")
    private String legalValidationUrl;

    /**
     * 支付审计结果
     */
    @JsonProperty("pay_audit_detail")
    private List<PayAuditDetailDto> payAuditDetailDto;

    /**
     * 注册的appid
     */
    @JsonProperty("registered_appid")
    private String registerAppId;

    /**
     * 支付签约url
     */
    @JsonProperty("sign_url")
    private String signUrl;
}
