package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.account;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.account.HeadImageInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.account.NicknameInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.account.SignatureInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.account.WxVerifyInfoDto;
import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2022/01/17
 **/
@Data
public class GetBasicInfoResp extends ErrorCode {

    private static final long serialVersionUID = -3883505267409061704L;

    @JsonAlias("appid")
    private String appId;

    /**
     * 帐号类型（1：订阅号，2：服务号，3：小程序）
     */
    @JsonAlias("account_type")
    private Integer accountType;

    /**
     * 主体类型
     */
    @JsonAlias("principal_type")
    private Integer principalType;

    /**
     * 	主体名称
     */
    @JsonAlias("principal_name")
    private String principalName;

    /**
     * 主体标识
     */
    @JsonAlias("credential")
    private String credential;

    /**
     * 实名验证状态
     */
    @JsonAlias("realname_status")
    private Integer realNameStatus;

    /**
     * 	微信认证信息
     */
    @JsonAlias("wx_verify_info")
    private WxVerifyInfoDto wxVerifyInfoDto;

    /**
     * 功能介绍信息
     */
    @JsonAlias("signature_info")
    private SignatureInfoDto signatureInfoDto;

    /**
     * 头像信息
     */
    @JsonAlias("head_image_info")
    private HeadImageInfoDto headImageInfoDto;

    /**
     * 名称信息
     */
    @JsonAlias("nickname_info")
    private NicknameInfoDto nicknameInfoDto;

    /**
     * 注册国家
     */
    @JsonAlias("registered_country")
    private Long registeredCountry;
}
