/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.miniprogram;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 小程序
 * 
 * @title MiniProgram
 * @desc 小程序
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
public class MiniProgram implements Serializable {

    private static final long serialVersionUID = -2702056175007431450L;

    /**
     * 所需跳转到的小程序appid（该小程序appid必须与发模板消息的公众号是绑定关联关系，暂不支持小游戏）
     */
    @JsonProperty("appid")
    @JsonAlias("appId")
    private String appId;

    /**
     * 所需跳转到小程序的具体页面路径，支持带参数,（示例index?foo=bar），要求该小程序已发布，暂不支持小游戏
     */
    @JsonProperty("pagepath")
    @JsonAlias("pagePath")
    private String pagePath;
}