/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 图片消息
 * 
 * @title ImageReqMsg
 * @desc 图片消息
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class ImageReqMsg extends BaseReqMsg {

    private static final long serialVersionUID = 8725169962065713239L;

    /**
     * 图片链接（由系统生成）
     */
    @JacksonXmlProperty(localName = "PicUrl")
    @JsonProperty("picurl")
    private String picUrl;

    /**
     * 图片消息媒体id，可以调用获取临时素材接口拉取数据。
     */
    @JacksonXmlProperty(localName = "MediaId")
    @JsonProperty("media_id")
    private String mediaId;
}