package cn.kinyun.scrm.weixin.sdk.entity.material.resp;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.material.dto.NewsContent;
import cn.kinyun.scrm.weixin.sdk.entity.material.dto.VideoMaterialDto;
import cn.kinyun.scrm.weixin.sdk.entity.media.Attachment;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * @ClassName NewsMaterialResp
 * @Description
 * @Author zhangjing
 * @DATE 2019/4/30 13:47
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class GetMaterialResp extends ErrorCode{
    private static final long serialVersionUID = 5668520256284381461L;
    /**
     * 类型:
     * 1: 图文素材
     * 2: 视频素材
     * 3: 图片,音频,缩略图素材
     */
    int type;
    /**
     * 图文素材,当media为图文时有效
     */
    private NewsContent news;

    /**
     * 视频素材,当media为video时有效
     */
    private VideoMaterialDto video;

    /**
     * 图片,音频,缩略图素材,当media为image,thumb,voice时有效
     */
    private Attachment attachment;
}
