package cn.kinyun.scrm.weixin.sdk.entity.component;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.dto.resp
 * @Description: 预授权码响应信息
 * @date Date : 2019年04月22日 14:36
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class PreAuthCode extends ErrorCode {
    private static final long serialVersionUID = -8450292480655896585L;

    /**
     * 预授权码
     */
    @JsonAlias("pre_auth_code")
    private String preAuthCode;

    /**
     * 有效期，10分钟
     */
    @JsonAlias("expires_in")
    private long expiresIn;
}
