package cn.kinyun.scrm.weixin.sdk.entity.component;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

import java.io.Serializable;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.entity.component
 * @date Date : 2019年06月02日 11:31
 */
@Data
public class AuthorizerInfo implements Serializable {

    private static final long serialVersionUID = 3719255008820054048L;

    /**
     * 授权方昵称
     */
    @JsonAlias("nick_name")
    private String nickName;

    /**
     * 授权方头像
     */
    @JsonAlias("head_img")
    private String headImg;

    /**
     * 授权方公众号类型，0代表订阅号，1代表由历史老帐号升级后的订阅号，2代表服务号
     * 授权方小程序类型, 0:普通小程序, 2或3:门店小程序 ,4:小游戏, 10:小商店, 12:使用小程序
     */
    @JsonAlias("service_type_info")
    private IdEntity serviceTypeInfo;

    /**
     * 公众号授权方认证类型，-1代表未认证，0代表微信认证，1代表新浪微博认证，</br>
     * 2代表腾讯微博认证，3代表已资质认证通过但还未通过名称认证，</br>
     * 4代表已资质认证通过、还未通过名称认证，但通过了新浪微博认证，</br>
     * 5代表已资质认证通过、还未通过名称认证，但通过了腾讯微博认证</br>
     *
     * 小程序认证类型, -1: 未认证; 0: 微信认证
     *
     */
    @JsonAlias("verify_type_info")
    private IdEntity verifyTypeInfo;

    /**
     * 授权方公众号/小程序的原始ID
     */
    @JsonAlias("user_name")
    private String userName;

    /**
     * 公众号/小程序主体名称
     */
    @JsonAlias("principal_name")
    private String principalName;

    /**
     * 授权方公众号所设置的微信号，可能为空
     */
    private String alias;

    /**
     * 功能开通情况
     */
    @JsonAlias("business_info")
    private BussinessInfo businessInfo;

    /**
     * 公众号/小程序二维码图片的url
     */
    @JsonAlias("qrcode_url")
    private String qrcodeUrl;

    /**
     * 账号介绍（小程序）
     */
    private String signature;

    /**
     * 小程序配置，根据这个字段判断是否为小程序类型授权
     */
    @JsonAlias("MiniProgramInfo")
    private MiniProgramInfo miniProgramInfo;

}
