package cn.kinyun.scrm.weixin.sdk.entity.channels.resp;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@NoArgsConstructor
@AllArgsConstructor
@Data
public class OrderListGetResp extends ErrorCode {

    /** 订单id列表 */
    @JsonProperty("order_id_list")
    private List<String> ids;

    /** 分页参数，下一页请求回传 */
    @JsonProperty("next_key")
    private String nextKey;

    /** 是否还有下一页，true:有下一页；false:已经结束，没有下一页。 */
    @JsonProperty("has_more")
    private Boolean hasMore;
}
