package cn.kinyun.scrm.weixin.sdk.entity.channels.req;

import cn.kinyun.scrm.weixin.sdk.entity.channels.dto.TimeRange;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@NoArgsConstructor
@AllArgsConstructor
@Data
public class OrderListGetReq {

    @JsonProperty("create_time_range")
    private TimeRange createTimeRange;

    @JsonProperty("update_time_range")
    private TimeRange updateTimeRange;

    /** 订单状态，枚举值见 {@link cn.kinyun.scrm.weixin.sdk.entity.channels.enums.WxChannelOrderStatus} */
    @JsonProperty("status")
    private Integer status;

    /** 买家身份标识 */
    @JsonProperty("openid")
    private Integer openid;

    /**
     * 分页参数，上一页请求返回
     */
    @JsonProperty("next_key")
    private String nextKey;

    /**
     * 每页数量(不超过100)
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}
