package cn.kinyun.scrm.weixin.sdk.entity.channels.enums;

import lombok.Getter;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Getter
public enum WxChannelOrderStatus {

    /** 10 待付款 */
    UNPAID(10, "待付款"),
    /** 20 待发货（已付款/用户已付尾款） */
    PAID(20, "待发货"),
    /** 21 部分发货 */
    PART_DELIVERY(21, "部分发货"),
    /** 30 待收货 */
    DELIVERY(30, "待收货"),
    /** 100 完成 */
    COMPLETED(100, "已完成"),
    /** 190	商品超卖商家取消订单 */
    UNPAID_CANCEL(190, "已取消"),
    /** 200 全部商品售后之后，订单取消 */
    ALL_AFTER_SALE(200, "已取消"),
    /** 250 用户主动取消/待付款超时取消/商家取消 */
    CANCEL(250, "已取消");

    private final int key;

    private final String val;

    WxChannelOrderStatus(int key, String val) {
        this.key = key;
        this.val = val;
    }

    /**
     * 获取状态
     *
     * @param key 状态码
     * @return 状态
     */
    public static String getStatusStr(Integer key) {
        if (key == null) {
            return "未知";
        }
        for (WxChannelOrderStatus status : WxChannelOrderStatus.values()) {
            if (key.equals(status.getKey())) {
                return status.getVal();
            }
        }
        return String.valueOf(key);
    }

}
