package cn.kinyun.scrm.weixin.sdk.entity.channels.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Data
public class OrderPriceInfo {

    /** 商品总价，单位为分 */
    @JsonProperty("product_price")
    private Long productPrice;

    /**
     * 用户实付金额，单位为分
     * order_price = original_order_price - discounted_price - finder_discounted_price - deduction_price - change_down_price
     */
    @JsonProperty("order_price")
    private Long orderPrice;

    /** 运费，单位为分 */
    @JsonProperty("freight")
    private Long freight;

    /** 优惠金额，单位为分 */
    @JsonProperty("discounted_price")
    private Long discountedPrice;

    /** 是否有优惠 */
    @JsonProperty("is_discounted")
    private Boolean isDiscounted;

    /** 订单原始价格，单位为分 */
    @JsonProperty("original_order_price")
    private Long originalOrderPrice;

    /** 商品预估价格，单位为分 */
    @JsonProperty("estimate_product_price")
    private Long estimateProductPrice;

    /** 改价后降低金额，单位为分 */
    @JsonProperty("change_down_price")
    private Long changeDownPrice;

    /** 改价后运费，单位为分 */
    @JsonProperty("change_freight")
    private Long changeFreight;

    /** 是否修改运费 */
    @JsonProperty("is_change_freight")
    private Boolean isChangeFreighted;

    /** 是否使用了会员积分抵扣 */
    @JsonProperty("use_deduction")
    private Boolean useDeduction;

    /** 会员积分抵扣金额，单位为分 */
    @JsonProperty("deduction_price")
    private Long deductionPrice;

    /**
     * 商家实收金额，单位为分
     * merchant_receieve_price = original_order_price - discounted_price - deduction_price - change_down_price
     */
    @JsonProperty("merchant_receieve_price")
    private Long merchantReceivePrice;

    /**
     * 商家优惠金额，单位为分，含义同discounted_price
     */
    @JsonProperty("merchant_discounted_price")
    private Long merchantDiscountedPrice;

    /**
     * 达人优惠金额，单位为分
     */
    @JsonProperty("finder_discounted_price")
    private Long finderDiscountedPrice;
}
