package cn.kinyun.scrm.weixin.sdk.entity.channels.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Data
public class OrderPayInfo {

    /** 预支付id */
    @JsonProperty("prepay_id")
    private String prepayId;

    /** 预支付时间，秒级时间戳 */
    @JsonProperty("prepay_time")
    private Long prepayTime;

    /**
     * 支付时间，秒级时间戳, 先用后付订单(payment_method=2)本字段的值为用户确认先用后付订单的时间，
     * 抽奖0元订单(payment_method=3)或者会员积分兑换订单(payment_method=4)没有发生实际支付，本字段的值为下单时间
     */
    @JsonProperty("pay_time")
    private Long payTime;

    /**
     * 支付订单号，先用后付订单(payment_method=2)在用户实际扣款前(确认收货时)本字段为空,
     * 抽奖0元订单(payment_method=3)或者会员积分兑换订单(payment_method=4)本字段为空
     */
    @JsonProperty("transaction_id")
    private String transactionId;

    /**
     * 支付方式，已支付订单会返回本字段，具体枚举值请参考PaymentMethod枚举
     */
    @JsonProperty("payment_method")
    private Integer paymentMethod;

}
