package cn.kinyun.scrm.weixin.sdk.entity.channels.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Data
public class OrderInfo {

    /** 订单号 */
    @JsonProperty("order_id")
    protected String orderId;

    /** 订单状态，枚举值见 {@link cn.kinyun.scrm.weixin.sdk.entity.channels.enums.WxChannelOrderStatus} */
    @JsonProperty("status")
    protected Integer status;

    /** 买家身份标识 */
    @JsonProperty("openid")
    protected String openid;

    /** union id */
    @JsonProperty("unionid")
    protected String unionId;

    /** 订单详细数据信息 */
    @JsonProperty("order_detail")
    protected OrderDetailInfo orderDetail;

    /** 售后信息 */
    @JsonProperty("aftersale_detail")
    protected AfterSaleDetail afterSaleDetail;

    /** 创建时间 秒级时间戳 */
    @JsonProperty("create_time")
    protected Long createTime;

    /** 更新时间 秒级时间戳 */
    @JsonProperty("update_time")
    protected Long updateTime;

    /**
     * 是否礼物订单
     */
    @JsonProperty("is_present")
    private Boolean isPresent;
}
