package cn.kinyun.scrm.weixin.sdk.entity.channels.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Data
public class OrderDetailInfo {

    /** 商品列表 */
    @JsonProperty("product_infos")
    private List<OrderProductInfo> productInfos;

    /** 支付信息 */
    @JsonProperty("pay_info")
    private OrderPayInfo payInfo;

    /** 价格信息 */
    @JsonProperty("price_info")
    private OrderPriceInfo priceInfo;

    /** 配送信息 */
    @JsonProperty("delivery_info")
    private OrderDeliveryInfo deliveryInfo;

    /** 优惠券信息 */
    @JsonProperty("coupon_info")
    private OrderCouponInfo couponInfo;

    /** 额外信息 */
    @JsonProperty("ext_info")
    private OrderExtInfo extInfo;

    /** 分佣信息 */
    @JsonProperty("commission_infos")
    private List<OrderCommissionInfo> commissionInfos;

    /** 分享信息 */
    @JsonProperty("sharer_info")
    private OrderSharerInfo sharerInfo;

    /** 结算信息 */
    @JsonProperty("settle_info")
    private OrderSettleInfo settleInfo;

    /** 分享员信息 */
    @JsonProperty("sku_sharer_infos")
    private List<OrderSkuSharerInfo> skuSharerInfos;

    /**
     * 授权账号信息
     */
    @JsonProperty("agent_info")
    private OrderAgentInfo agentInfo;

    /**
     * 订单来源信息
     */
    @JsonProperty("source_info")
    private OrderSourceInfo sourceInfo;

    /**
     * 订单退款信息
     */
    @JsonProperty("refund_info")
    private OrderRefundInfo refundInfo;

}
