package cn.kinyun.scrm.weixin.sdk.entity.channels.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Data
public class OrderDeliveryInfo {

    /** 地址信息 */
    @JsonProperty("address_info")
    private OrderAddressInfo addressInfo;

    /** 发货物流信息 */
    @JsonProperty("delivery_product_info")
    private List<DeliveryProductInfo> deliveryProductInfos;

    /** 发货完成时间，秒级时间戳 */
    @JsonProperty("ship_done_time")
    private Long shipDoneTime;

    /** 订单发货方式，0普通物流 1虚拟发货，由商品的同名字段决定 */
    @JsonProperty("deliver_method")
    private Integer deliverMethod;

    /** 用户下单后申请修改收货地址，商家同意后该字段会覆盖订单地址信息 */
    @JsonProperty("address_under_review")
    private OrderAddressInfo addressUnderReview;

    /** 修改地址申请时间，秒级时间戳 */
    @JsonProperty("address_apply_time")
    private Long addressApplyTime;

    /** 电子面单代发时的订单密文 */
    @JsonProperty("ewaybill_order_code")
    private String ewaybillOrderCode;

    /**
     * 订单质检类型
     * 2：生鲜类质检；
     * 1：珠宝玉石类质检；
     * 0：不需要；
     * 不传递本字段表示不需要
     */
    @JsonProperty("quality_inspect_type")
    private Integer qualityInspectType;

    /**
     * 质检信息，quality_inspect_type>0时返回，具体结构请参考QualityInsepctInfo结构体
     */
    @JsonProperty("quality_inspect_info")
    private QualityInspectInfo qualityInspectInfo;

    /**
     * 虚拟商品充值账户信息, 具体结构参考RechargeInfo结构体
     */
    @JsonProperty("recharge_info")
    private RechargeInfo rechargeInfo;


}
