package cn.kinyun.scrm.weixin.sdk.entity.channels.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Data
public class OrderAddressInfo {

    /** 虚拟发货订单联系方式(deliver_method=1时返回) */
    @JsonProperty("virtual_order_tel_number")
    private String virtualOrderTelNumber;

    /** 收件人姓名 */
    @JsonProperty("user_name")
    private String userName;

    /** 收件人手机号码 */
    @JsonProperty("tel_number")
    private String telNumber;

    /** 邮编 */
    @JsonProperty("postal_code")
    private String postalCode;

    /** 省份 */
    @JsonProperty("province_name")
    private String provinceName;

    /** 城市 */
    @JsonProperty("city_name")
    private String cityName;

    /** 区 */
    @JsonProperty("county_name")
    private String countyName;

    /** 详细地址 */
    @JsonProperty("detail_info")
    private String detailInfo;

    /** 国家码 */
    @JsonProperty("national_code")
    private String nationalCode;

    /** 门牌号码 */
    @JsonProperty("house_number")
    private String houseNumber;

    /**
     * 额外的联系方式信息（虚拟号码相关），具体结构请参考TelNumberExtInfo结构体
     */
    @JsonProperty("tel_number_ext_info")
    private TelNumberExtInfo telNumberExtInfo;

    /**
     * 0：不使用虚拟号码，1：使用虚拟号码
     */
    @JsonProperty("use_tel_number")
    private Integer useTelNumber;

    /**
     * 标识当前店铺下一个唯一的用户收货地址
     */
    @JsonProperty("hash_code")
    private String hashCode;


}
