package cn.kinyun.scrm.weixin.sdk.entity.channels.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Data
public class DeliveryProductInfo {

    /** 快递单号 */
    @JsonProperty("waybill_id")
    private String waybillId;

    /** 快递公司编码 */
    @JsonProperty("delivery_id")
    private String deliveryId;

    /** 包裹中商品信息 */
    @JsonProperty("product_infos")
    private List<FreightProductInfo> productInfos;

    /** 快递公司名称 */
    @JsonProperty("delivery_name")
    private String deliveryName;

    /** 发货时间，秒级时间戳 */
    @JsonProperty("delivery_time")
    private Long deliveryTime;

    /** 配送方式，枚举值见DeliveryType */
    @JsonProperty("deliver_type")
    private Integer deliverType;

    /** 发货地址 */
    @JsonProperty("delivery_address")
    private OrderAddressInfo deliveryAddress;
}
