/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.basic;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 公众号接口调用凭证
 * 
 * @title AccessToken
 * @desc 公众号接口调用凭证
 * @author yanmaoyuan
 * @date 2019年4月30日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AccessToken extends ErrorCode {

    private static final long serialVersionUID = 6439887916580418869L;

    /**
     * 公众号接口调用凭证
     */
    @JsonProperty("access_token")
    private String accessToken;

    /**
     * 凭证有效时间 (单位：秒)
     */
    @JsonProperty("expires_in")
    private int expires = 7200;
}