package cn.kinyun.scrm.weixin.sdk.api.channels;

import cn.kinyun.scrm.weixin.sdk.entity.channels.req.ProductGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.channels.resp.ProductGetResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.Objects;

/**
 * @author Created by chenjiaqiang on 2025/01/08
 **/
@Slf4j
@Component
public class WxChannelsProductAPI {

    @Value("${wx.channels.product.get}")
    private String productGetUrl;

    @Autowired
    private RestTemplate restTemplate;

    public ProductGetResp productGet(@NonNull String accessToken, @NonNull ProductGetReq req) {
        log.info("productGet with req={}", req);

        Preconditions.checkArgument(StringUtils.isNoneBlank(accessToken), "accessToken不能为空");
        Preconditions.checkArgument(Objects.nonNull(req), "req不能为空");

        ResponseEntity<ProductGetResp> resp = null;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        // 构造请求体
        HttpEntity<ProductGetReq> httpEntity = new HttpEntity<>(req, headers);

        // 发送请求
        String url = MessageFormat.format(productGetUrl, accessToken);
        resp = restTemplate.postForEntity(url, httpEntity, ProductGetResp.class);

        ProductGetResp result = resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

}
