package cn.kinyun.scrm.weixin.sdk.api.channels;

import cn.kinyun.scrm.weixin.sdk.entity.channels.req.OrderListGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.channels.resp.OrderGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.channels.resp.OrderListGetResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;

/**
 * @author Created by chenjiaqiang on 2024/12/26
 **/
@Slf4j
@Component
public class WxChannelsOrderAPI {

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 订单接口-获取订单列表 POST
     */
    @Value("${wx.channels.order.list.get}")
    private String orderListGetUrl;

    /**
     * 订单接口-获取订单详情 POST
     */
    @Value("${wx.channels.order.get}")
    private String orderGetUrl;

    /**
     * 获取订单列表
     * @param accessToken
     * @param req
     * @return
     */
    public OrderListGetResp orderListGet(@NonNull String accessToken, @NonNull OrderListGetReq req) {
        log.info("orderListGet with req={}", req);

        Preconditions.checkArgument(StringUtils.isNoneBlank(accessToken), "accessToken不能为空");
        Preconditions.checkArgument(Objects.nonNull(req), "req不能为空");

        ResponseEntity<OrderListGetResp> resp = null;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        // 构造请求体
        HttpEntity<OrderListGetReq> httpEntity = new HttpEntity<>(req, headers);

        // 发送请求
        String url = MessageFormat.format(orderListGetUrl, accessToken);
        resp = restTemplate.postForEntity(url, httpEntity, OrderListGetResp.class);

        OrderListGetResp result = resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    /**
     * 获取订单详情
     * @param accessToken
     * @param orderId
     * @return
     */
    public OrderGetResp orderGet(@NonNull String accessToken, @NonNull String orderId) {
        log.info("orderGet with orderId={}", orderId);

        Preconditions.checkArgument(StringUtils.isNoneBlank(accessToken), "accessToken不能为空");
        Preconditions.checkArgument(StringUtils.isNoneBlank(orderId), "orderId不能为空");

        Map<String, String> req = Maps.newHashMap();
        req.put("order_id", orderId);

        ResponseEntity<OrderGetResp> resp = null;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        // 构造请求体
        HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(req, headers);

        // 发送请求
        String url = MessageFormat.format(orderGetUrl, accessToken);
        resp = restTemplate.postForEntity(url, httpEntity, OrderGetResp.class);

        OrderGetResp result = resp.getBody();
        WeixinException.isSuccess(result);
        return result;

    }


}
