package cn.kinyun.scrm.weixin.sdk.api.applet;


import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkReq;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkResp;
import cn.kinyun.scrm.weixin.sdk.entity.applet.QrcodeCreateReq;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.HttpsClient;
import com.kuaike.common.utils.JacksonUtil;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.net.ssl.HttpsURLConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;

/**
 * @author sunwen
 */
@Slf4j
@Component
public class AppletQrcodeAPI {

    @Autowired
    private RestTemplate restTemplate;

    @Value("${wx.get.unlimited.qrcode.url}")
    private String getUnlimitedQrcodeUrl;

    @Value("${wx.generate.url.link.url}")
    private String generateUrlLinkUrl;

    private static final String POST = "POST";

    private static final String QRCODE_DIR = "./qrcodeDir/";

    public File getUnlimitedQrcodeFile(@NonNull String accessToken, @NonNull QrcodeCreateReq req) throws Exception {
        log.info("getUnlimitedQRCode,req:{}", JacksonUtil.obj2Str(req));

        String url = MessageFormat.format(getUnlimitedQrcodeUrl, accessToken);
        HttpsClient client = new HttpsClient();
        // 创建https请求连接
        HttpsURLConnection https = client.getHttpsURLConnection(url);
        // 设置header和ssl证书
        client.setHttpsHeader(https, POST, false, null, null, null);
        // 保持连接
        https.setRequestProperty("connection", "Keep-Alive");
        https.setRequestProperty("Content-Type", "application/json");

        // 获取输出流
        OutputStream os = https.getOutputStream();
        os.write(JacksonUtil.obj2Str(req).getBytes());

        https.connect();

        File dir = new File(QRCODE_DIR);
        if (!dir.exists()) {
            dir.mkdirs();// NOSONAR
        }
        String fileName = QRCODE_DIR + req.getScene() + ".jpeg";
        File file = new File(fileName);
        // 获取输入流
        InputStream in = https.getInputStream();

        try (FileOutputStream fos = new FileOutputStream(file)){
            byte[] bytes = new byte[1024];
            int len = in.read(bytes);
            do {
                fos.write(bytes, 0, len);
                len = in.read(bytes);
            } while (len != -1);
        } finally {
            os.close();
        }

        return file;
    }


    public GenerateUrlLinkResp generateUrlLinkUrl(@NonNull String accessToken, @NonNull GenerateUrlLinkReq req) {
        log.info("generateUrlLinkUrl req:{}", req);
        String url = MessageFormat.format(generateUrlLinkUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<GenerateUrlLinkReq> request = new HttpEntity<>(req, headers);
        ResponseEntity<GenerateUrlLinkResp> response = restTemplate.postForEntity(url, request, GenerateUrlLinkResp.class);
        GenerateUrlLinkResp result = response.getBody();
        if (result != null) {
            WeixinException.isSuccess(result);
        }
        return result;
    }

}
