package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ChangeOrderInfoItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhangjing
 * @date 2022/1/4 7:54 下午
 */
@Data
public class OrderPriceChangeReq {

    /**
     * 必填, 订单id
     */
    @JsonProperty("order_id")
    private Long orderId;

    /**
     * 必填, 是否修改运费
     */
    @JsonProperty("change_express")
    private Boolean changeExpress;

    /**
     * 非必填, 修改后的运费价格（change_express=true时要指定，不填默认为0），以分为单位
     */
    @JsonProperty("express_fee")
    private Long expressFee;

    /**
     * 必填
     */
    @JsonProperty("change_order_infos")
    private List<ChangeOrderInfoItem> changeOrderInfos;

}
