package cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address.AddressInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address.AddressType;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/10 8:11 下午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class AddressItemDto {

    /**
     * 地址ID
     */
    @JsonProperty("address_id")
    private Long addressId;

    /**
     * 联系人姓名(废弃)
     */
    private String name;

    /**
     * 座机
     */
    private String landline;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否为发货地址(1是0否)
     */
    @JsonProperty("send_addr")
    private Integer sendAddr;

    /**
     * 是否为默认发货地址(1是0否)
     */
    @JsonProperty("default_send")
    private Integer defaultSend;

    /**
     * 是否为收货地址(1是0否)
     */
    @JsonProperty("recv_addr")
    private Integer recvAddr;

    /**
     * 是否为默认收货地址(1是0否)
     */
    @JsonProperty("default_recv")
    private Integer defaultRecv;

    /**
     * 创建时间
     */
    @JsonProperty("create_time")
    private Long createTime;

    /**
     * 更新时间
     */
    @JsonProperty("update_time")
    private Long updateTime;

    /**
     * 地址类型
     */
    @JsonProperty("address_type")
    private AddressType addressType;

    /**
     * 地址信息
     */
    @JsonProperty("address_info")
    private AddressInfo addressInfo;

}
