package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.category;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2022/01/18
 **/
@Data
public class CategoriesDto {

    /**
     * 类目 ID
     */
    @JsonAlias("id")
    private Integer id;

    /**
     * 类目名称
     */
    @JsonAlias("name")
    private String name;

    /**
     * 类目层级
     */
    @JsonAlias("level")
    private Integer level;

    /**
     * 类目父级 ID
     */
    @JsonAlias("father")
    private Integer father;

    /**
     * 子级类目 ID
     */
    @JsonAlias("children")
    private List<Integer> children;

    /**
     * 是否为敏感类目（1 为敏感类目，需要提供相应资质审核；0 为非敏感类目，无需审核）
     */
    @JsonAlias("sensitive_type")
    private Integer sensitiveType;

    /**
     * sensitive_type 为 1 的类目需要提供的资质证明
     */
    @JsonAlias("qualify")
    private CategoryQualifyDto qualify;
}
