package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName ScanCodePushEvent
 * @Description scancode_push：扫码推事件的事件推送
 * @Author zhangjing
 * @DATE 2019/4/26 9:56
 * @Version 1.0
 */
@Data
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper=true)
public class ScanCodePushEvent extends BaseEvent {

    private static final long serialVersionUID = 652123988333727312L;

    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    @JacksonXmlProperty(localName = "ScanCodeInfo")
    private ScanCodeInfo scanCodeInfo;
}