/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 客服账号列表
 * 
 * @title CustomAccountList
 * @desc 客服账号列表
 * @author yanmaoyuan
 * @date 2019年4月29日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CustomAccountList extends ErrorCode {

    private static final long serialVersionUID = -3976935979316131275L;

    /**
     * 客服账号列表
     */
    @JsonProperty("kf_list")
    private List<CustomAccount> list;
}