
package cn.kinyun.scrm.weixin.sdk.entity.component;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.component.api.entity;
 * @Description: 第三方平台access_token响应信息
 * @date Date : 2019年04月22日 14:36
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class AuthorizerOption extends ErrorCode {
    private static final long serialVersionUID = 3537171920874242101L;
    
    /**
     * 授权公众号或小程序的appid
     */
    @JsonAlias("authorizer_appid")
    private String authorizerAppId;
    
    /**
     * 选项名称
     */
    @JsonAlias("option_name")
    private String optionName;
    
    /**
     * 选项值
     */
    @JsonAlias("option_value")
    private String optionValue;

}

    